moment_fun = function(p){
alpha = p[1]
beta = p[2]
v = p[3]

f1 = digamma(alpha + v) - digamma(alpha) + mean(log(x)) - mean(log(abs(x+beta)))
f2 = v/beta - (alpha+v)*mean(1/(abs(x+beta)))
f3 = digamma(alpha + v) - digamma(v) + log(abs(beta)) - mean(log(abs(x+beta)))
f = c(f1, f2, f3)

J11 = trigamma(alpha + v) - trigamma(alpha)
J12 = - mean(1/(abs(x+beta)))
J13 = trigamma(alpha + v)
J21 = J12
J22 = - v/(beta^2) + (alpha + v)*mean(1/((abs(x+beta))^2))
J23 = 1/beta- mean(1/(abs(x+beta)))
J31 = J13
J32 = J23
J33 = trigamma(alpha + v) - trigamma(v)
J = matrix(c(J11, J12, J13,
			 J21, J22, J23,
			 J31, J32, J33), nrow=3, byrow = TRUE)

list(f=f, J=J)
}

## ep=1e-8, it_max=10000
## ep=1e-8, it_max=20
## ep=1e-5, it_max=20
Newtons = function (fun, y, ep=1e-8, it_max=10000){
    index<-0; k<-1
    while (k<=it_max){
        y1 <- y; obj <- fun(y);
        y  <- y - solve(obj$J, obj$f);
        norm <- sqrt((y-y1) %*% (y-y1))
        if (norm<ep){
            index<-1; break
        }
        k<-k+1
    }
    obj <- fun(y);
    list(root=y, it=k, index=index, FunVal=obj$f, norm=norm)
}

Moment_estimators = function(x){
n = length(x)
A1 = mean(x)
M2 = (n - 1) * var(x) / n
M3 = mean(x^3)
 
C=A1*(M2+A1^2)
beta_1=(C*(M3-C)-2 * A1 * M2 * M3)/(2 * C * M2-(M3-C)*A1^2); beta_1
alpha_1=2 * (beta_1*C+A1*M3)/((M3-C)*beta_1); alpha_1
v_1=beta_1 * alpha_1/A1+1; v_1

res = c(alpha_1, beta_1, v_1)
}

Moment_estimators_EX_EX2_EX3 = function(x){
A1 = mean(x)
A2 = mean(x^2) 
A3 = mean(x^3)
 
beta_1=(A2*A3+A1*(A2)^2-2*A3*(A1^2))/(A1*A3-2*A2^2+A1^2*A2);beta_1
#v_1=(2*A2-A1^2+A1*beta_1)/(A2-A1^2);v_1
v_1=(3*A1*A2*A3+5*A1^2*A2^2-4*A2^3-3*A1^3*A3-A1^4*A2)/(A1*A2*A3+3*A1^2*A2^2-2*A2^3-A1^3*A3-A1^4*A2)
#alpha_1=A1*(v_1-1)/beta_1;alpha_1
alpha_1=2*(A1^2*A3+A1^3*A2-2*A1*A2^2)*(A1*A2*A3+A1^2*A2^2-A2^3-A1^3*A3)/((A2*A3+A1*A2^2-2*A1^2*A3)*(A1*A2*A3+3*A1^2*A2^2-2*A2^3-A1^3*A3-A1^4*A2))
res = c(alpha_1, beta_1, v_1)
}

Moment_estimators_EX_EX2_EX3_new = function(x){
A1 = mean(x)
A2 = mean(x^2) 
A3 = mean(x^3)

alpha_1 = (-2 * A1^2 * A3 + 2 * A1 * A2^2) / (2 * A1^2 * A3 - A1 * A2^2 - A2 * A3)
beta_1 = (-2 * A1^2 * A3 + A1 * A2^2 + A2 * A3) / (A1^2 * A2 + A1 * A3 - 2 * A2^2)
v_1 = (A1^2 * A2 + 3 * A1 * A3 - 4 * A2^2) / (A1^2 * A2 + A1 * A3 - 2 * A2^2)

res = c(alpha_1, beta_1, v_1)
}

Pearson_chisquare_test = function(nn, p, r){
## nn - frequencies
## p  - theoretical probabilities
## r  - number of unknown parameters

n = sum(nn)
m = length(nn)
K = sum((nn - n * p)^2 / (n * p))
df = m - 1 - r
P_value = 1 - pchisq(K, df = df)

res = data.frame(Chisquare = K, P_value = P_value, df = df, m = m, n = n)
}

Marginal_density = function(x){
res = gamma(alpha+v)/(gamma(alpha)*gamma(v))*(1/x)*((x/(x+Beta))^alpha)*((Beta/(x+Beta))^v)
}

Marginal_density_alpha_beta_v = function(x, alpha, Beta, v){
res = gamma(alpha+v)/(gamma(alpha)*gamma(v))*(1/x)*((x/(x+Beta))^alpha)*((Beta/(x+Beta))^v)
}

p_IG_IG_alpha_Beta_v = function(x, alpha, Beta, v){
alpha <<- alpha
Beta <<- Beta
v <<- v
	
L_x = length(x)
I_value = I_abs_error = numeric(L_x)
for (i in 1:L_x){
	I_i = integrate(f = Marginal_density, lower = 0, upper = x[i])
	I_value[i] = I_i$value
	I_abs_error[i] = I_i$abs.error
}


# res = list(I_value = I_value, I_abs_error = I_abs_error)
res = I_value
}

Generate_Matrix_Latex = function(A){
m = nrow(A)
n = ncol(A)

C = rep("c", n, sep=""); C
temp = "[c]{"
for (i in 1:n){
temp = paste(temp, C[i], sep="")
}
temp = paste(temp, "}", sep="")

B = matrix("0", nrow = m, ncol = 2*n); B
for (i in 1:m){
	for (j in 1:n){
		B[i, 2*j-1] = A[i, j]
		B[i, 2*j]   = "&"
	}
}
B[, 2*n] = "\\\\"
B[m, 2*n] = ""
B

One = "\\begin{tabular}"
Two = temp
Three = B
Four = "\\end{tabular}"

cat(One, "\n", Two, "\n"); for (i in 1:m) cat(B[i, ], "\n");  cat(Four, "\n")
}

Compute_Proportions_vector_pmin = function(v1, v2, v3){
min_v = pmin(v1, v2, v3)
Proportions = numeric(3)
Proportions[1] = mean(v1 == min_v) 
Proportions[2] = mean(v2 == min_v) 
# Proportions[3] = mean(v3 == min_v) 
Proportions[3] = 1 - Proportions[1] - Proportions[2] # to avoid several minimums

res = Proportions
}

Compute_Proportions_vector_pmax = function(v1, v2, v3){
max_v = pmax(v1, v2, v3)
Proportions = numeric(3)
Proportions[1] = mean(v1 == max_v) 
Proportions[2] = mean(v2 == max_v) 
# Proportions[3] = mean(v3 == max_v) 
Proportions[3] = 1 - Proportions[1] - Proportions[2] # to avoid several maximums

res = Proportions
}

Compute_Estimators_PESLs = function(x, alpha, beta, v){
n = length(x)
alpha1 = alpha + n * v
beta1 = 1 / (sum(1/x) + 1/beta)

delta_s = 1 / (alpha1 * beta1)
delta_2 = 1 / ((alpha1 - 1) * beta1)
PESL_s = log(alpha1) - digamma(alpha1)
PESL_2 = 1 / (alpha1 - 1) + log(alpha1 - 1) - digamma(alpha1)

res = data.frame(
delta_s = delta_s, 
delta_2 = delta_2, 
PESL_s = PESL_s,
PESL_2 = PESL_2
)
}

Compute_Estimators_PESLs_new = function(x_np1, alpha, beta, v){
alpha1 = alpha + v
beta1 = 1 / (1/x_np1 + 1/beta)

delta_s = 1 / (alpha1 * beta1)
delta_2 = 1 / ((alpha1 - 1) * beta1)
PESL_s = log(alpha1) - digamma(alpha1)
PESL_2 = 1 / (alpha1 - 1) + log(alpha1 - 1) - digamma(alpha1)

res = data.frame(
delta_s = delta_s, 
delta_2 = delta_2, 
PESL_s = PESL_s,
PESL_2 = PESL_2
)
}

Compute_PostDist_Estimators_PESLs_new = function(alpha, beta, v, x_np1){
alpha1 = alpha + v
beta1  = 1 / (1/x_np1 + 1/beta)

PostDist_theta = 1 / rgamma(n = 1e4, shape = alpha1, scale = beta1)
delta_s = 1 / (alpha1 * beta1)
delta_2 = 1 / ((alpha1 - 1) * beta1)
PESL_s = log(alpha1) - digamma(alpha1)
PESL_2 = 1 / (alpha1 - 1) + log(alpha1 - 1) - digamma(alpha1)

res = list(
PostDist_theta = PostDist_theta,
delta_s = delta_s,
delta_2 = delta_2, 
PESL_s = PESL_s,
PESL_2 = PESL_2
)
}

plot_estimator = function(delta_s, delta_2, parameter, xlab, para_name, legend_pos = "topleft", sub){
dev.new()
col = c("blue", "red")
lty = 1:2
xlim = range(parameter)
ylim = range(delta_s, delta_2)
#ylim=c(0:1)
plot(parameter, delta_s, type = "n", xlim = xlim, ylim = ylim, xlab = xlab, ylab = "Estimator", sub = sub)
lines(parameter, delta_s, lty = lty[1], col = col[1], lwd = 4)
lines(parameter, delta_2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c("delta_s", "delta_2")
legend(x = legend_pos, legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/Estimator_", para_name, "_change", sep = ""), type = c("pdf"))
savePlot(filename = paste("figure/Estimator_", para_name, "_change", sep = ""), type = c("jpg"))
}

plot_PESL = function(PESL_s, PESL_2, parameter, xlab, para_name, legend_pos = "topleft", sub){
dev.new()
col = c("blue", "red")
lty = 1:2
xlim = range(parameter)
ylim = range(PESL_s, PESL_2)
plot(parameter, PESL_s, type = "n", xlim = xlim, ylim = ylim, xlab = xlab, ylab = "PESL", sub = sub)
lines(parameter, PESL_s, lty = lty[1], col = col[1], lwd = 4)
lines(parameter, PESL_2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c("PESL_s", "PESL_2")
legend(x = legend_pos, legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/PESL_", para_name, "_change", sep = ""), type = c("pdf"))
savePlot(filename = paste("figure/PESL_", para_name, "_change", sep = ""), type = c("jpg"))
}

Compute_Proportions_2vectors_pmin = function(v1, v2){
min_v = pmin(v1, v2)
Proportions = numeric(2)
Proportions[1] = mean(v1 == min_v) 
# Proportions[2] = mean(v2 == min_v) 
Proportions[2] = 1 - Proportions[1] # to avoid several minimums

res = Proportions
}



